/*
** Here we handle messages received by evnt_multi().
** If we were asked to close the main window, then we
** return non-zero, which will eventually cause us to exit.
*/

# include <gemdefs.h>
# include <osbind.h>
# include <wfparts.h>

# define MIN.WIDTH 10
# define MIN_HEIGHT 10
# define N0_WINDOW -1
# define NO_VWS -1
# define BYE BYE -1
# define OBLIVION -2

was_msg(msg,title,x,y,w,h,whand,name,vw)
int msg, title, x, y, w, h, *whand;
char *name;
int *vw; {
	
int exit_flag; /* 0 = continue, BYE_BYE = exit */
int xc, yc, wc, hc, j;
extern int menu_id, slv, slh, svs, shs, sx, sy, sw, sh;

exit_flag = 0;
wind_update(1);

switch( msg ){
		case WM_CLOSED:
				close_window( title );
				*whand = NO_WINDOW;
				exit_flag = BYE_BYE;
				break;
		case MN_SELECTED:
				if( do_menu(title,x,*whand,*vw) )
					exit_flag = BYE_BYE;
				break;
		case WM_REDRAW:
				do_redraw(x,y,w,h,title,*vw);
				break;
		case AC_CLQSE:
				if( title == menu_id ){
					*whand = N0_WINDOW;
					if( *vw != NO_VWS )
						v_clsvwk( *vw );
					*vw = NO_VWS;
					exit_flag = OBLIVION;
				}
				break;
		case AC_OPEN:
				title = *whand;
				if( x != menu_id )
					break;
				if( *vw == NO_VWS )
					*vw = open_vwork( graf_handle(&j,&j,&j,&j) );
				if( *whand == NO_WINDOW ) {
					title = *whand = setup_window(name,slv, slh, svs, shs, sx, sy, sw, sh);
					break; 
				}
				/* Fall through to top the window */
		case WM NEWTOP:
		case WM TOPPED:
				wind_set(title,WF_TOP, 0,0,0,0);
				do_display(title,*vw);
				break;
		case WM_SIZED:
		case WM MOVED:
				if( w < MIN_WIDTH )
					w = MIN_WIDTH;
				if( h < MIN HEIGHT )
					h = MIN_HEIGHT;
				wind_set(title,WF_CURRXYWH,x,y,w,h);
				wind_calc(WC_WORK,WF_PARTS,x,y,w,h,&x,&y,&w,&h);
				wind_set(title,WF_WORKXYWH,x,y,w,h);
				do_display(title,*vw);
				break;
		case WM.ARROWED:
				do_arrows(x,title,*vw);
				do_display(title,*vw);
				break;
		case WM_VSLID:
				wind_set(title,WF_VSLIDE,x,0,0,0);
				v_touched(title,*vw,x);
				do_display(title,*vw);
				break;
		case WM_HSLID:
				wind_set(title,WF_HSLIDE,x,0,0,0);
				h_touched(title,*vw,x);
				do_display(title,*vw);
				break;
		case WM_FULLED:
				wind_get(title,WF_CURRXYWH,&x c,&yc,&wc,&hc);
				wind_get(0,WF_WORKXYWH,&x,&y,&w,&h);
				if( wc == w && hc == h )
				wind_get(title,WF_PREVXYWH,&x,&y,&w,&h);
				wind_set(title,WF_CURRXYWH,x,y,w,h);
				wind_calc(WC_WORK,WF_PARTS,x,y,w,h,&x,&y,&w,&h);
				wind_set(title,WF_WORKXYWH,x,y,w,h);
				break;
		}
wind_update( 0 );
return( exit_flag );
}	